from selenium.webdriver.firefox.webdriver import WebDriver

class BasePage:
    HEADER_LOCATOR = ("xpath", "//header")
    HOME_BUTTON_LOCATOR = ("xpath", "//a[@rel='home']")

    def __init__(self, driver):
        self.driver: WebDriver = driver

    def open(self):
        self.driver.get(self.PAGE_URL)

    def find_and_click(self, tuple):
        element = self.driver.find_element(*tuple)
        self.driver.execute_script("arguments[0].scrollIntoView({block: 'center', behavior: 'instant'});", element)
        element.click()

    def home(self):
        self.driver.find_element(*self.HOME_BUTTON_LOCATOR)